//-----------------------------------------------------------
#define STRICT 1
#define WIN32_LEAN_AND_MEAN
//-----------------------------------------------------------
#include <windows.h>
#include <winnt.h>
#include <stdlib.h>
#include <stdio.h>
#include <tchar.h>
#ifdef UNICODE
  #include <Shellapi.h>
#else
  #include <dos.h>
#endif
//------------------------------------------------
static bool openProcess(LPCTSTR name, bool hide);
//------------------------------------------------
static int usage(LPCTSTR name);
//------------------------------------------------
int WINAPI WinMain(HINSTANCE,HINSTANCE,LPSTR,int)
{
  TCHAR path[_MAX_PATH] = _T("");
  int delay = 0;
  bool hide = false;
#ifdef UNICODE
  int __argc = 0;
  LPWSTR* __argv = CommandLineToArgvW(GetCommandLineW(), &__argc);
  if(!__argv)
    return EXIT_FAILURE;
#endif

  for(int i = 1; i < __argc; ++i) {
    LPTSTR arg = __argv[i];
    if(_T('-') == arg[0] || _T('/') == arg[0]) {
      ++arg;
      switch(arg[0]) {
        case _T('d'):
        case _T('D'):
          delay = _ttoi(arg + 1);
          break;
        case _T('h'):
        case _T('H'):
          hide = true;
          break;
        case _T('r'):
        case _T('R'):
          _tcscpy_s(path, arg + 1);
          break;
        }
      }
    }

  int result = EXIT_SUCCESS;
  if(!*path)
    usage(__argv[0]);

  else {
    if(!delay)
      delay = 1000;

    Sleep(delay);

    TCHAR drive[_MAX_PATH];
    TCHAR dir[_MAX_PATH];
    _tsplitpath_s(path, drive, _MAX_PATH, dir, _MAX_PATH, 0, 0, 0, 0);
    TCHAR t[_MAX_PATH];
    _tmakepath_s(t, drive, dir, 0, 0);
    SetCurrentDirectory(t);
    if(!openProcess(path, hide))
      result = EXIT_FAILURE;
    }
#ifdef UNICODE
  LocalFree(__argv);
#endif
  return result;
}
//----------------------------------------------------------------------------
static bool openProcess(LPCTSTR name, bool hide)
{
  STARTUPINFO si;
  ZeroMemory(&si, sizeof(si));
  si.cb = sizeof(si);
  si.dwFlags = STARTF_FORCEONFEEDBACK;
  if(hide) {
    si.dwFlags |= STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_HIDE;
    }
  PROCESS_INFORMATION pi;
  TCHAR path[_MAX_PATH];
  _tcscpy_s(path, name);
  if(CreateProcess(0, path, 0, 0, 0, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi)) {
    WaitForInputIdle(pi.hProcess, 3 * 1000);
    CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);
    return true;
    }
  return false;
}
//------------------------------------------------
#define MSG_USAGE _T("Digitare %s /R<applic> [/D<xxx>] [/H]\r\n\r\ndove:\r\n<applic>\t l'applicazione da avviare\r\n<xxx>\tindica il numero di msec di attesa (default: 1000)\r\n/H\tindica avvio nascosto\r\n")
#define TITLE_USAGE _T("Uso del programma")
//------------------------------------------------
static int usage(LPCTSTR name)
{
  TCHAR info[512];
  TCHAR appl[_MAX_PATH];
  _tsplitpath_s(name, 0, 0, 0, 0, appl, _MAX_PATH, 0, 0);
  wsprintf(info, MSG_USAGE, appl);
  MessageBox(0, info, TITLE_USAGE, MB_OK | MB_ICONINFORMATION);
  return EXIT_SUCCESS;
}
