//------------- PShape.h -----------------------------------------------------
//----------------------------------------------------------------------------
#ifndef PShape_H_
#define PShape_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
class PShape;
//------------------------------------------------------------------------------
class PShapeMov
{
  public:
    PShapeMov() {}
    virtual ~PShapeMov() {}
    virtual void move(PShape& obj) { moveZ(obj); }
    void moveZ(PShape& obj);
    static SIZE szScreen;
};
//------------------------------------------------------------------------------
class PShape
{
  public:
    PShape(const SIZE& size, float stepX, float stepY, float stepZ, int zOrder) : Size(size), stepX(stepX),
        stepY(stepY), stepZ(stepZ), X(0), Y(0), Z(0), zOrder(zOrder) { }
    virtual ~PShape() {}

    virtual bool init(float x, float y, float z) { X = x; Y = y; Z = z; return true; }
    virtual void move(PShapeMov& f) { f.move(*this); }

    virtual void evPaint(HDC hdc) = 0;

    float& coord_X() { return X; }
    float& coord_Y() { return Y; }
    float& coord_Z() { return Z; }
    float& step_X() { return stepX; }
    float& step_Y() { return stepY; }
    float& step_Z() { return stepZ; }
    int getWidth() const { return Size.cx; }
    int getHeight() const { return Size.cy; }
    int getZOrder() const { return zOrder; }
  protected:
    SIZE Size;
    float X;
    float Y;
    float Z;
    float stepX;
    float stepY;
    float stepZ;

    int zOrder;
};
//------------------------------------------------------------------------------
PShape* allocShape(const SIZE& size, float stepX, float stepY, float stepZ);
//------------------------------------------------------------------------------
#endif
