//------- pSetting.h -----------------------------------------------------
//----------------------------------------------------------------------------
#ifndef pSetting_H_
#define pSetting_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
#include <ScrnSave.h>
#include "Resource.h"
//------------------------------------------------------------------------------
BOOL WINAPI RegisterDialogClasses(HANDLE instance);
BOOL WINAPI ScreenSaverConfigureDialog(HWND dlg, UINT message, WPARAM wParam, LPARAM lParam);
//------------------------------------------------------------------------------
class pSetting
{
  public:
    pSetting(HWND hwnd) : Hwnd(hwnd) {}
    virtual ~pSetting() {}

    virtual bool init() { return true; }
    virtual void loadSettings() = 0;
    virtual void storeSettings() = 0;
    virtual void end() { }

    virtual BOOL ScreenSaverConfigureDialog(HWND dlg, UINT message, WPARAM wParam, LPARAM lParam) = 0;
    operator HWND() const { return Hwnd; }
  protected:
    HWND getHwnd() const { return Hwnd; }
  private:
    HWND Hwnd;
};
//------------------------------------------------------------------------------
pSetting* allocSetting(HWND hwnd);
//------------------------------------------------------------------------------
#endif
