//------------ pSetting.cpp ---------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include "pSettings.h"
//------------------------------------------------------------------------------
BOOL WINAPI RegisterDialogClasses(HANDLE instance)
{
  return TRUE;
}
//------------------------------------------------------------------------------
BOOL WINAPI ScreenSaverConfigureDialog(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  static pSetting *settings = NULL;

  switch (message) {
    case WM_INITDIALOG:
      settings = allocSetting(hwnd);
      if(settings->init())
        settings->loadSettings();
      return TRUE;

    case WM_COMMAND:
      switch(LOWORD(wParam)) {
        case IDOK:
          settings->storeSettings();
          // fall through
        case IDCANCEL:
          settings->end();
          delete settings;
          settings = 0;
          EndDialog(hwnd, LOWORD(wParam) == IDOK);
          return TRUE;
        }
      break;
    }
  if(settings)
    return settings->ScreenSaverConfigureDialog(hwnd, message, wParam, lParam);
  return FALSE;
}
//------------------------------------------------------------------------------
