//------- PScreenSaver.cpp ---------------------------------------------------
//------------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include "PScreenSaver.h"
//------------------------------------------------------------------------------
LRESULT WINAPI ScreenSaverProc(HWND wnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  static PScreenSaver* ScreenSaver;
  switch (message) {
    case WM_CREATE:
      if(!ScreenSaver) {
        ScreenSaver = allocScreenSaver(wnd);
        if(!ScreenSaver->init())
          PostQuitMessage(0);
        }
      return 0;
    case WM_TIMER:
      ScreenSaver->evTimer(wParam);
      break;
    case WM_ERASEBKGND:
      if(!ScreenSaver->eraseBkg())
        break;
      return 1;

    case WM_PAINT:
      do {
        PAINTSTRUCT ps = {NULL};
        HDC hDC = BeginPaint(wnd, &ps);
        ScreenSaver->evPaint(hDC);
        EndPaint(wnd, &ps);
        } while(false);
      return 0;
    case WM_DESTROY:
      delete ScreenSaver;
      ScreenSaver = 0;
      return 0;
    }
#ifdef my_DEBUG
  return 0;
#else
  return DefScreenSaverProc(wnd, message, wParam, lParam);
#endif
}
//------------------------------------------------------------------------------
PScreenSaver::~PScreenSaver()
{
  if(idTimer) {
    KillTimer(hwnd, idTimer);
    idTimer = 0;
    }
}
//------------------------------------------------------------------------------
