//-------- pDisplay.cpp --------------------------------------------------------
//------------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include "pDisplay.h"
#include "pShape.h"
//------------------------------------------------------------------------------
#include <dxerr9.h>
//------------------------------------------------------------------------------
pDisplay::pDisplay(HWND hwnd)
{
  direct3D = Direct3DCreate9(D3D_SDK_VERSION);
  if (!direct3D)
    throw "Direct3DCreate9(...) failed";

  D3DDISPLAYMODE displayMode;
  direct3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &displayMode);

  ZeroMemory(&presentationParameters, sizeof(presentationParameters));
  presentationParameters.BackBufferFormat = displayMode.Format;
  presentationParameters.SwapEffect = D3DSWAPEFFECT_DISCARD;
#ifdef my_DEBUG
  presentationParameters.Windowed = TRUE;
#else
  presentationParameters.BackBufferWidth = PShapeMov::szScreen.cx;
  presentationParameters.BackBufferHeight = PShapeMov::szScreen.cy;
#endif
  HRESULT hRes;
#if 1
  DWORD mSampleQlt;
  presentationParameters.MultiSampleType = D3DMULTISAMPLE_NONE;

  for(uint i = D3DMULTISAMPLE_16_SAMPLES; i >= D3DMULTISAMPLE_2_SAMPLES; --i) {
    hRes = direct3D->CheckDeviceMultiSampleType(D3DADAPTER_DEFAULT,
                            D3DDEVTYPE_HAL,
                            D3DFMT_A8R8G8B8,
                            presentationParameters.Windowed,
                            (D3DMULTISAMPLE_TYPE)i,
                            &mSampleQlt
                          );

    if(hRes == D3D_OK) {
      presentationParameters.MultiSampleType = (D3DMULTISAMPLE_TYPE)i;
      presentationParameters.MultiSampleQuality = mSampleQlt - 1;
      break;
      }
    }
#endif
  if FAILED(hRes = direct3D->CreateDevice(
        D3DADAPTER_DEFAULT,
//        D3DDEVTYPE_REF, // software
        D3DDEVTYPE_HAL, // hardware
        hwnd,
        D3DCREATE_SOFTWARE_VERTEXPROCESSING,
        &presentationParameters,
        &direct3DDevice))
    throw "Direct3DCreateDevice9(...) failed";
//    throw DXGetErrorString9(hRes);
}
//------------------------------------------------------------------------------
pDisplay::~pDisplay()
{
  if(direct3DDevice) {
    direct3DDevice->Release();
    direct3DDevice = NULL;
    }

  if(direct3D) {
    direct3D->Release();
    direct3D = NULL;
    }
}
//------------------------------------------------------------------------------
static bool checkLimit(int& col, int& step, int maxV)
{
  col += step;
  if(col >= maxV)
    step = -step;
  else if(col<= 0) {
    step = -step;
    col = 0;
    return true;
    }
  return false;
}
//------------------------------------------------------------------------------
void getRGB_BKG(int& r, int& g, int& b)
{
#if 1
#define LIMIT_R 67
#define LIMIT_G 59
#define LIMIT_B 73

  static int R = rand() % LIMIT_R;
  static int G = rand() % LIMIT_G;
  static int B = rand() % LIMIT_B;
  static int stepR = 1;
  static int stepG = 1;
  static int stepB = 1;
  static unsigned int count;
  if(!(++count & 7)) {
    checkLimit(R, stepR, LIMIT_R);
    checkLimit(G, stepG, LIMIT_G);
    checkLimit(B, stepB, LIMIT_B);
    }
#else
  static int R = 1;
  static int G;
  static int B;
  static int step = 2;
  static int count;
  if(!(++count & 15)) {
    if(R) {
      if(checkLimit(R, step, 65))
        G = 1;
      }
    else if(G) {
      if(checkLimit(G, step, 55))
        B = 1;
      }
    else if(B) {
      if(checkLimit(B, step, 70))
        R = 1;
      }
    }
#endif
  r = R;
  g = G;
  b = B;
}
//------------------------------------------------------------------------------
int pDisplay::beginPaint()
{
  if (IsDeviceReset()) {
    int R;
    int G;
    int B;
    getRGB_BKG(R, G, B);
    direct3DDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(R, G, B), 1.0f, 0);
    return SUCCEEDED(direct3DDevice->BeginScene()) ? 2 : 1;
    }
  return 0;
}
//------------------------------------------------------------------------------
void pDisplay::endPaint(bool full)
{
  if(full)
    direct3DDevice->EndScene();
  direct3DDevice->Present(NULL, NULL, NULL, NULL);
}
//------------------------------------------------------------------------------
bool pDisplay::IsDeviceReset()
{
  HRESULT hRes;

  switch (direct3DDevice->TestCooperativeLevel()) {
    case D3DERR_DEVICELOST:
      return false;
    case D3DERR_DEVICENOTRESET:
      if FAILED(hRes = direct3DDevice->Reset(&presentationParameters))
        return false;
//        throw DXGetErrorString8(hRes);
      return true;
    }
  return true;
}
//------------------------------------------------------------------------------
