//------- npScreensaver.h ----------------------------------------------------
//----------------------------------------------------------------------------
#ifndef npScreensaver_H_
#define npScreensaver_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
#include "pbitmap.h"
#include "PScreenSaver.h"
#include "npShape.h"
#include "DirectDraw.h"
#include "pDisplay.h"
//----------------------------------------------------------------------------
class npScreenSaver : public PScreenSaver
{
  private:
    typedef PScreenSaver baseClass;
  public:
    npScreenSaver(HWND hwnd, uint msec = 1);
    virtual ~npScreenSaver();

    virtual bool init();
    virtual void evTimer(uint idT);
    virtual void evPaint(HDC hdc);
    virtual bool eraseBkg() { return true; }

  private:
    void evPaintD3D(HDC hdc);
    void evPaintDX(HDC hdc);
    void evPaintGDI(HDC hdc);
    void (npScreenSaver::*ev_Paint)(HDC hdc);
    PVect<PShape*> Shapes;
    PVect<int> casualMove;

    // DirectX
    Direct::PrimarySurface* pPrimarySS;
    Direct::OffScreenSurface* pOffSS;
    Direct::Draw* pdDraw;
    Direct::Draw* getDirect() { return pdDraw; }
    Direct::OffScreenSurface* getOffSurface() { return pOffSS; }
    Direct::PrimarySurface* getPrimarySurface() { return pPrimarySS; }

    void setDirect(Direct::Draw* pdd);
    void addBmp(LPCTSTR p, int zOrder);
    void invalidate(PShape& shape);

    HBITMAP hBmpWork;
    HDC mdcWork;
    HGDIOBJ oldObj;
    bool makeMDC();
    void setGDIPaint();

    // D3D
    pDisplay* Display;
};

//------------------------------------------------------------------------------
#endif
