//------------ npShapeD3D.h --------------------------------------------------
//----------------------------------------------------------------------------
#ifndef npShapeD3D_H_
#define npShapeD3D_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include <d3d9.h>
#include <d3d9types.h>
#include "npShape.h"
//------------------------------------------------------------------------------
class npShapeD3D : public npShape
{
  private:
    typedef npShape baseClass;
  public:
    npShapeD3D(PBitmap* bmp, float stepX, float stepY, float stepZ, int zOrder,
        IDirect3DDevice9* pd3dDevice);
    virtual ~npShapeD3D();
    virtual bool init(float x, float y, float z);

    virtual void evPaint(HDC hdc);
  protected:
    IDirect3DDevice9* pd3dDevice;
    LPDIRECT3DTEXTURE9 SpriteTexture;
    LPDIRECT3DTEXTURE9 SpriteTexture2;

    void releaseAll();
    void paintTexture(float x, float y, float z, const D3DCOLOR& diffuse, LPDIRECT3DTEXTURE9 sprite);
};
//------------------------------------------------------------------------------
#endif
