//------------ npShapeD3D.cpp ------------------------------------------------
//----------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include "npShapeD3D.h"
#include "p_util.h"
#include "p_file.h"
#include <D3dx9tex.h>
//------------------------------------------------------------------------------
npShapeD3D::npShapeD3D(PBitmap* bmp, float stepX, float stepY, float stepZ, int zOrder,
      LPDIRECT3DDEVICE9 pd3dDevice) :
        baseClass(bmp, stepX, stepY, stepZ, zOrder), pd3dDevice(pd3dDevice),
        SpriteTexture(0)
{
}
//------------------------------------------------------------------------------
npShapeD3D::~npShapeD3D()
{
  releaseAll();
}
//------------------------------------------------------------------------------
void npShapeD3D::releaseAll()
{
  if(SpriteTexture) {
    SpriteTexture->Release();
    SpriteTexture = 0;
    }
 }
//------------------------------------------------------------------------------
struct Vertex {
  float x, y, z, rhw;
  D3DCOLOR diffuse;
  float tu, tv;
};
#define FVF_VERTEX (D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1)
//------------------------------------------------------------------------------
void npShapeD3D::paintTexture(float x, float y, float z, const D3DCOLOR& diffuse, LPDIRECT3DTEXTURE9 sprite)
{
  const float sourceLeft = 0;
  const float sourceTop = 0;
  D3DSURFACE_DESC desc;
  sprite->GetLevelDesc(0, &desc);
  float sourceRight = (float)getWidth() / (float)desc.Width;
  float sourceBottom = (float)getHeight() / (float)desc.Height;

  float destLeft = x - 0.5f;
  float destTop = y - 0.5f;

  float destRight = destLeft + getWidth();
  float destBottom = destTop + getHeight();

  pd3dDevice->SetTexture(0, sprite);

  const float cz = 0.0f, rhw = 1.0f;
#if 1
  destRight = (destRight - destLeft) * z + destLeft;
  destBottom = (destBottom - destTop) * z + destTop;
#else
  float W = destRight - destLeft;
  float W2 = W * z;
  destLeft += (W - W2) / 2;

  float H = destBottom - destTop;
  float H2 = H * z;
  destTop += (H - H2) / 2;

  destRight = W2 + destLeft;
  destBottom = H2 + destTop;
#endif
  Vertex vertices[4] = {
    // x, y, z, rhw, diffuse, tu, tv
    {destLeft, destTop, cz, rhw, diffuse, sourceLeft, sourceTop},
    {destRight, destTop, cz, rhw, diffuse, sourceRight, sourceTop},
    {destLeft, destBottom, cz, rhw, diffuse, sourceLeft, sourceBottom},
    {destRight, destBottom, cz, rhw, diffuse, sourceRight, sourceBottom}
  };
  pd3dDevice->SetFVF(FVF_VERTEX);
  pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(Vertex));
}
//------------------------------------------------------------------------------
void npShapeD3D::evPaint(HDC hdc)
{
  if(!SpriteTexture)
    return;

  static uint blend = 255;

  static uint blend2 = 254;
  static int count;

  if(!(++count & 15)) {
    static int step = 1;
    blend2 += step;
    if(blend2 >= 255 || blend2 <= 127)
      step = -step;
    }

  const float z = 0.0f, rhw = 1.0f;

  D3DCOLOR diffuse = D3DCOLOR_ARGB(255, blend, blend2, blend2);
  paintTexture(coord_X(), coord_Y(), coord_Z(), diffuse, SpriteTexture);
}
//------------------------------------------------------------------------------
#define OPAQUE_MASK 0xff000000
//------------------------------------------------------------------------------
#define SEMI_TRANSP_MASK 0xdf000000
//------------------------------------------------------------------------------
static
void addPixMask(DWORD& pix, DWORD mask)
{
#if 0
  if(OPAQUE_MASK != mask)
    pix = ((pix & 0xff) / 2) | (((pix & 0xff00) / 2) & 0xff00) | (((pix & 0xff0000) / 2) & 0xff0000);
#endif
  pix |= mask;
}
//------------------------------------------------------------------------------
static
bool copyToSprite(LPDIRECT3DTEXTURE9 sprite, LPDWORD pBits, const SIZE& sz, DWORD mask)
{
  D3DLOCKED_RECT LockedRect;
  HRESULT Result = sprite->LockRect(0, &LockedRect, NULL, 0);
  if(D3D_OK != Result)
    return false;
  DWORD* DestData = (DWORD*)LockedRect.pBits;
  DWORD pix = *pBits;
  //This is set to the end and then copies backwards for some reason
  pBits += sz.cx * (sz.cy - 1);
  for(int y = 0; y < sz.cy; ++y) {
    //set this rows background color to transparent to transparent
    DWORD* Row = pBits;
    for(int k = 0;  k < sz.cx; ++k, ++Row) {
      if(*Row == pix)
        //set alpha to full transparent
        *Row = 0x00000000;
      else {
        //set alpha to opaque by mask
//        *Row &= 0x00ffffffff;
        addPixMask(*Row, mask);
//        *Row |= mask;
        }
      }
    // copy this row of pixels
    memcpy(DestData, pBits, sz.cx * sizeof(DWORD));

    // skip past row of pixels
    DestData += (LockedRect.Pitch / 4);
    pBits -= sz.cx;
    }
  sprite->UnlockRect(0);
  return true;
}
//------------------------------------------------------------------------------
extern DWORD getMask();
//------------------------------------------------------------------------------
bool npShapeD3D::init(float x, float y, float z)
{
  bool success = baseClass::init(x, y, z);
  if(!success)
    return false;
  SIZE sz = Bmp->getSize();
  if(!SpriteTexture) {
    HRESULT Result = pd3dDevice->CreateTexture(sz.cx, sz.cy, 1, 0, D3DFMT_A8R8G8B8,
        D3DPOOL_MANAGED, &SpriteTexture, 0);
    // se non riesce pu dipendere dalla mancanza di D3D hardware, allora si prova con
    // la funzione diretta che dovrebbe dare successo
    if(D3D_OK != Result) {
      Result = D3DXCreateTexture(pd3dDevice, sz.cx, sz.cy, 1, 0, D3DFMT_A8R8G8B8,
        D3DPOOL_MANAGED, &SpriteTexture);
      if(D3D_OK != Result)
        return false;
      }
    }

  HDC hdc = GetDC(0);

  DWORD image_length = (DWORD)sz.cx * (DWORD)sz.cy;
  LPDWORD buff = new DWORD[image_length];

  BITMAP bmp;
  ZeroMemory(&bmp, sizeof(bmp));
  GetObject((HGDIOBJ)(HBITMAP)*Bmp, sizeof(bmp), &bmp);

  BITMAPINFOHEADER bmih;
  ZeroMemory(&bmih, sizeof(bmih));
  bmih.biSize = sizeof(BITMAPINFOHEADER);
  bmih.biWidth = bmp.bmWidth;
  bmih.biHeight = bmp.bmHeight;
  bmih.biPlanes = bmp.bmPlanes;
  bmih.biBitCount =  32;
  bmih.biCompression = BI_RGB;

  success = GetDIBits(hdc, *Bmp, 0L, sz.cy, buff, (LPBITMAPINFO)&bmih, DIB_RGB_COLORS);
  if(success)
    success = copyToSprite(SpriteTexture, buff, sz, getMask());

  DeleteDC( hdc );
  delete []buff;
  return success;
}
//----------------------------------------------------------------------------
