//------------ npShape.cpp ---------------------------------------------------
//----------------------------------------------------------------------------
#include "precHeader.h"
//------------------------------------------------------------------------------
#include "npShape.h"
#include "p_util.h"
#include "pTraspBitmap.h"
#include <math.h>
//------------------------------------------------------------------------------
SIZE PShapeMov::szScreen =
{
  GetSystemMetrics(SM_CXSCREEN),
  GetSystemMetrics(SM_CYSCREEN)
};
//------------------------------------------------------------------------------
static void getZoomedRect(PShape& obj,  PRect& r)
{
  int offsX = (r.right - int(r.right * obj.coord_Z() + 0.5f)) / 2;
  int offsY = (r.bottom - int(r.bottom * obj.coord_Z() + 0.5f)) / 2;
  r.Inflate(-offsX, -offsY);
}
//------------------------------------------------------------------------------
void npShapeMovLinear::move(PShape& obj)
{
  PShapeMov::move(obj);
  PRect r(0, 0, szScreen.cx, szScreen.cy);
//  getZoomedRect(obj, r);
  float pos = obj.coord_X() + obj.step_X();
//  pos *= obj.coord_Z();
  if(pos < r.left) {
    obj.coord_X() = 0;
    obj.step_X() = -obj.step_X();
    }
  else if(pos + obj.getWidth() > r.right) {
    obj.coord_X() = float(szScreen.cx - obj.getWidth());
    obj.step_X() = -obj.step_X();
    }
  else
    obj.coord_X() = pos;

  pos = obj.coord_Y() + obj.step_Y();
//  pos *= obj.coord_Z();
  if(pos < r.top) {
    obj.coord_Y() = 0;
    obj.step_Y() = -obj.step_Y();
    }
  else if(pos + obj.getHeight() > r.bottom) {
    obj.coord_Y() = float(szScreen.cy - obj.getHeight());
    obj.step_Y() = -obj.step_Y();
    }
  else
    obj.coord_Y() = pos;
}
//------------------------------------------------------------------------------
void npShapeMovCasual::move(PShape& obj)
{
  PShapeMov::move(obj);
  float step = ((rand() & 255) + 1) / 127.0f;
  step *= obj.step_X();

  float pos = obj.coord_X() + step;
//  pos *= obj.coord_Z();
  if(pos < 0) {
    obj.coord_X() = 0;
    obj.step_X() = -obj.step_X();
    }
  else if(pos + obj.getWidth() > szScreen.cx) {
    obj.coord_X() = float(szScreen.cx - obj.getWidth());
    obj.step_X() = -obj.step_X();
    }
  else
    obj.coord_X() = pos;

  step = ((rand() & 255) + 1) / 127.0f;
  step *= obj.step_Y();
  pos = obj.coord_Y() + step;
//  pos *= obj.coord_Z();
  if(pos < 0) {
    obj.coord_Y() = 0;
    obj.step_Y() = -obj.step_Y();
    }
  else if(pos + obj.getHeight() > szScreen.cy) {
    obj.coord_Y() = float(szScreen.cy - obj.getHeight());
    obj.step_Y() = -obj.step_Y();
    }
  else
    obj.coord_Y() = pos;
}
//------------------------------------------------------------------------------
#define pi      3.141592625
//------------------------------------------------------------------------------
#define MAX_STEP_MOVE2 0.13f
//------------------------------------------------------------------------------
void npShapeMovVarious::move(PShape& obj)
{
  PShapeMov::move(obj);
  if(obj.step_Y() < 1.0f) {
    obj.step_Y() = (float)(rand() % PShapeMov::szScreen.cy);
    obj.step_X() = (float)(rand() % 360);
    }
  double alpha = obj.step_X() * pi / 180;
  double xpos = PShapeMov::szScreen.cx - obj.getWidth();
  double ypos = (PShapeMov::szScreen.cy - obj.getHeight()) / 2 + obj.step_Y();

  obj.coord_X() = float(xpos / 2 + xpos * sin(alpha) * cos(alpha) * cos(alpha * 3));
//  obj.coord_X() = float(xpos / 2 + xpos * sin(alpha) * cos(alpha));// * cos(2 * alpha));
  ypos = ypos + (ypos * cos(alpha));// + obj.step_Y();

  if(ypos < 0)
    ypos = -ypos;
  while(ypos > (PShapeMov::szScreen.cy - obj.getHeight())) {
    ypos = (PShapeMov::szScreen.cy - obj.getHeight()) * 2 - ypos;
    if(ypos < 0)
      ypos = -ypos;
    }
  obj.coord_Y() = (float)ypos;
  obj.step_X() = float((obj.step_X() >= 360) ? 0 :  obj.step_X() + MAX_STEP_MOVE2);
}
//------------------------------------------------------------------------------
void npShapeMovGravity::move(PShape& obj)
{
  PShapeMov::move(obj);

  float pos = obj.coord_X() + obj.step_X();
  if(pos < 0) {
    obj.coord_X() = 0;
    obj.step_X() = -obj.step_X();
    }
  else if(pos + obj.getWidth() > szScreen.cx) {
    obj.coord_X() = float(szScreen.cx - obj.getWidth());
    obj.step_X() = -obj.step_X();
    }
  else
    obj.coord_X() = pos;
  double alpha = obj.step_Y();
  if(alpha > 180)
    alpha = 360 - alpha;
  alpha *= pi / 180;
  pos = float(PShapeMov::szScreen.cy - obj.getHeight());
  pos -= pos * (float)sin(alpha);
  obj.step_Y() = obj.step_Y() >= 360 ? 0 :  obj.step_Y() + MAX_STEP_MOVE2;

  if(pos < 0)
    obj.coord_Y() = 0;
  else if(pos + obj.getHeight() > szScreen.cy)
    obj.coord_Y() = float(szScreen.cy - obj.getHeight());
  else
    obj.coord_Y() = pos;
}
//------------------------------------------------------------------------------
void PShapeMov::moveZ(PShape& obj)
{
#define MIN_F 0.2f
#define MAX_F 1.8f
  float pos = obj.coord_Z() + obj.step_Z();
  if(pos < MIN_F) {
    obj.coord_Z() = MIN_F;
    obj.step_Z() = -obj.step_Z();
    }
  else if(pos  > MAX_F) {
    obj.coord_Z() = MAX_F;
    obj.step_Z() = -obj.step_Z();
    }
  else
    obj.coord_Z() = pos;
}
//------------------------------------------------------------------------------
npShape::npShape(PBitmap* bmp, float stepX, float stepY, float stepZ, int zOrder) :
        baseClass(bmp->getSize(), stepX, stepY, stepZ, zOrder), Bmp(new PBitmap(*bmp))
{ }
//------------------------------------------------------------------------------
npShape::~npShape() { delete Bmp;  }
//------------------------------------------------------------------------------
void npShape::evPaint(HDC hdc)
{
  POINT pt = { ROUND_POS_REAL(coord_X()), ROUND_POS_REAL(coord_Y()) };
#if 1
  // N.B il primo parametro  una PWin*, viene richiamato nella Invalidate() e nella moveTo()
  // e, se zero, manda in crash, in questo caso  possibile passare zero perch si limita
  // al solo disegno
  PTraspBitmap(0, Bmp, pt).Draw(hdc);
#else
  Bmp->draw(hdc, pt);
#endif
}
//------------------------------------------------------------------------------
