//------------ npSetting.cpp ---------------------------------------------------
#include "precHeader.h"
#include "npSettings.h"
#include "npCommon.h"
#include "macro_utils.h"
#include "popensave.h"
#include "p_file.h"
//------------------------------------------------------------------------------
static DWORD Mask = (DWORD)-1;
DWORD getMask()
{
	if((DWORD)-1 == Mask) {
		Mask = getKeyValue(OPACITY_USE);
		if(!Mask)
			Mask = 0x7f;
		Mask <<= (8 * 3);
		}
	return Mask;
}
//------------------------------------------------------------------------------
static DWORD ZOrder = (DWORD)-1;
bool useZOrder()
{
	if((DWORD)-1 == ZOrder)
		ZOrder = getKeyValue(USE_Z_ORDER);
	return ZOrder ? true : false;
}
//------------------------------------------------------------------------------
pSetting* allocSetting(HWND hwnd)
{
  return new npSetting(hwnd);
}
//------------------------------------------------------------------------------
BOOL npSetting::ScreenSaverConfigureDialog(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message) {
    case WM_COMMAND:
      switch(LOWORD(wParam)) {
        case IDC_BUTTON_OPEN:
          searchPath();
          return TRUE;
        }
      break;
    }
  return FALSE;
}
//------------------------------------------------------------------------------
void npSetting::loadSettings()
{
  TCHAR buff[_MAX_PATH];
  GetModuleDirName(SIZE_A(buff), buff);
  getKeyValue(SVISOR_PATH, buff, true);
  if(*buff)
    SET_TEXT(IDC_PATH, buff);

  _tcscpy_s(buff, _T("npScreenSaver.txt"));
  getKeyValue(FILE_NAME, buff, true);
  if(*buff)
    SET_TEXT(IDC_FILE, buff);
  DWORD val = getKeyValue(GRAPHIC_USE);
  switch(val) {
    case 0:
      SET_CHECK(IDC_RADIO_D3D);
      break;
    case 1:
      SET_CHECK(IDC_RADIO_DDX);
      break;
    case 2:
      SET_CHECK(IDC_RADIO_GDI);
      break;
    }
  val = getKeyValue(USE_Z_ORDER);
  if(val)
  	SET_CHECK(IDC_CHECK_ZORDER);
  val = getKeyValue(OPACITY_USE);
  SET_INT(IDC_EDIT_OPACITY, val);
}
//------------------------------------------------------------------------------
void npSetting::storeSettings()
{
  TCHAR buff[_MAX_PATH];
  GET_TEXT(IDC_PATH, buff);
  setKeyValue(SVISOR_PATH, buff);
  GET_TEXT(IDC_FILE, buff);
  setKeyValue(FILE_NAME, buff);
  DWORD v = IS_CHECKED(IDC_RADIO_D3D) ? 0 : IS_CHECKED(IDC_RADIO_DDX) ? 1 : 2;
  setKeyValue(GRAPHIC_USE, v);
  v = IS_CHECKED(IDC_CHECK_ZORDER) ? 1 : 0;
  setKeyValue(USE_Z_ORDER, v);
  GET_INT(IDC_EDIT_OPACITY, v);
  setKeyValue(OPACITY_USE, v);
}
//------------------------------------------------------------------------------
void npSetting::searchPath()
{
  TCHAR path[_MAX_PATH];
  GET_TEXT(IDC_PATH, path);
  if(!*path)
    getKeyValue(SVISOR_PATH, path);
  if(PChooseFolder(*this, path, _T("Percorso base")))
    SET_TEXT(IDC_PATH, path);
}
