//------- npScreenSaver.cpp ---------------------------------------------------
#include "precHeader.h"
#include "npScreenSaver.h"
#include "pregistry.h"
#include "npCommon.h"
#include "p_txt.h"
#include "p_file.h"
#include "npShapeD3D.h"
//----------------------------------------------------------------------------
#ifdef my_DEBUG
//----------------------------------------------------------------------------
class mainWin : public PMainWin
{
  public:
    mainWin(HINSTANCE hInstance)  : PMainWin(_T("Screen Saver Test"), hInstance) {}
    ~mainWin() { destroy(); }

    virtual bool preProcessMsg(MSG& msg) { return toBool(IsDialogMessage(getHandle(), &msg)); }

  protected:
    virtual LRESULT windowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};
//----------------------------------------------------------------------------
class ScreenSaverApp : public PAppl
{
  public:
    ScreenSaverApp(HINSTANCE hInstance, int nCmdShow) :
      PAppl(hInstance, nCmdShow)  {   }
  protected:
    virtual PWin* initMainWindow(LPCTSTR title, HINSTANCE hInstance)
    {
      return new mainWin(hInstance);
    }
};
//----------------------------------------------------------
LRESULT mainWin::windowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  ScreenSaverProc(hwnd, message, wParam, lParam);
  if(WM_ERASEBKGND == message)
    return 1;
  return PMainWin::windowProc(hwnd, message, wParam, lParam);
}
//----------------------------------------------------------------------------
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR lpCmdLine, int nCmdShow)
{
  return ScreenSaverApp(hInstance, nCmdShow).run(_T("Screen Saver Test"));
}
//----------------------------------------------------------------------------
#else
//----------------------------------------------------------------------------
  #ifdef _UNICODE
    #pragma comment(lib, "scrnsavw.lib")
  #else
    #pragma comment(lib, "scrnsave.lib")
  #endif
#endif
//----------------------------------------------------------------------------
#define ID_INIT_FONT 21
#define MAX_FONT     20
//----------------------------------------------------------------------------
#define ID_INIT_BMP  (ID_INIT_FONT + MAX_FONT)
#define MAX_BMP     20
//----------------------------------------------------------------------------
#define ID_INIT_VAR  100
#define MAX_VAR       20
//----------------------------------------------------------------------------
#define ID_INIT_VAR_INFO  (ID_INIT_VAR + 100)
//----------------------------------------------------------------------------
void setKeyValue(LPCTSTR keyName, LPCTSTR path)
{
  PRegKeyStr key(keyName, path);
  PRegistry().writeKey(key, SUB_BASE_KEY);
}
//----------------------------------------------------------------------------
void getKeyValue(LPCTSTR keyName, LPTSTR path, bool writeIfNotExist)
{
  PRegKeyStr key(keyName);
  if(PRegistry::SUCCESS == PRegistry().readKey(key, SUB_BASE_KEY))
    _tcscpy_s(path, _MAX_PATH, key.getString());
  else if(writeIfNotExist && path[0])
    setKeyValue(keyName, path);
  else
    path[0] = 0;
}
//-----------------------------------------------------------------------------
void setKeyValue(LPCTSTR keyName, DWORD val)
{
  PRegKeyDWORD key(keyName, val);
  PRegistry().writeKey(key, SUB_BASE_KEY);
}
//-----------------------------------------------------------------------------
DWORD getKeyValue(LPCTSTR keyName, DWORD value, bool writeIfNotExist)
{
  PRegKeyDWORD key(keyName);
  if(PRegistry::SUCCESS == PRegistry().readKey(key, SUB_BASE_KEY))
    return key.getDWORD();
  else if(writeIfNotExist) {
    setKeyValue(keyName, value);
    return value;
    }
  else
    return 0;
}
//-----------------------------------------------------------------------------
PScreenSaver* allocScreenSaver(HWND hwnd)
{
  return new npScreenSaver(hwnd);
}
//-----------------------------------------------------------------------------
static
int getCurrRes()
{
  HDC hdc = GetDC(NULL);
  int bpp = GetDeviceCaps(hdc, BITSPIXEL);
  ReleaseDC(NULL, hdc);
  return bpp;
}
//-----------------------------------------------------------------------------
inline DWORD def_size_image()
{
  return (PShapeMov::szScreen.cx * PShapeMov::szScreen.cy * 3 + 80 + 1023) & ~1023;
}
//-----------------------------------------------------------------------------
npScreenSaver::npScreenSaver(HWND hwnd, uint msec) : baseClass(hwnd, msec),
      pPrimarySS(0), pOffSS(0), pdDraw(0), ev_Paint(0),
      hBmpWork(0), mdcWork(0), Display(0)
{
  CoInitialize(NULL);
}
//-----------------------------------------------------------------------------
npScreenSaver::~npScreenSaver()
{
  flushPV(Shapes);
  delete pPrimarySS;
  delete pOffSS;
  delete pdDraw;

  if(hBmpWork) {
    SelectObject(mdcWork, oldObj);
    DeleteDC(mdcWork);
    DeleteObject(hBmpWork);
    }
  delete Display;
  CoUninitialize();
}
//----------------------------------------------------------------------------
bool npScreenSaver::makeMDC()
{
  if(hBmpWork)
    return true;
  HDC hdc = GetDC(*this);
  hBmpWork = CreateCompatibleBitmap(hdc, PShapeMov::szScreen.cx, PShapeMov::szScreen.cy);
  if(hBmpWork) {
    mdcWork = CreateCompatibleDC(hdc);
    oldObj = SelectObject(mdcWork, hBmpWork);
    ReleaseDC(*this, hdc);
    return true;
    }
  return false;
}
//-----------------------------------------------------------------------------
bool npScreenSaver::init()
{
  if(!baseClass::init())
    return false;
  srand(GetTickCount());
  DWORD vGrph = getKeyValue(GRAPHIC_USE);
  PRect r;
  GetWindowRect(*this, r);
  bool fullScreen = r.Width() == PShapeMov::szScreen.cx && r.Height() == PShapeMov::szScreen.cy;
  if(!vGrph) { // D3D
    try {
      Display = new pDisplay(*this);
      ev_Paint = &npScreenSaver::evPaintD3D;
      }
    catch (...)  {
      if(fullScreen)
        setKeyValue(GRAPHIC_USE, 1);
      delete Display;
      Display = 0;
      ++vGrph;
      }
    }
  if(1 == vGrph) { // DirectX
    try {
      Direct::Draw* pdd = new Direct::Draw;
      pdd->SetFullScreen(*this);
      setDirect(pdd);
      }
    catch (...)  {
      if(fullScreen)
        setKeyValue(GRAPHIC_USE, 2);
      setDirect(0);
      }
    }
  else if(2 == vGrph) // GDI
    setDirect(0);

  TCHAR basePath[_MAX_PATH];
  GetModuleDirName(SIZE_A(basePath), basePath);
  getKeyValue(SVISOR_PATH, basePath, true);
  if(!*basePath)
    return false;
  setOfString set;
  do {
    TCHAR filename[_MAX_PATH] = _T("npScreenSaver.txt");
    getKeyValue(FILE_NAME, filename, true);
    if(!*filename)
      break;
    TCHAR path[_MAX_PATH];
    _tcscpy_s(path, basePath);
    appendPath(path, filename);
    set.add(path);
    } while(false);
  if(!set.setFirst())
    return false;

  LPTSTR pPath = basePath + _tcslen(basePath);
  for(uint i = 0; i < MAX_BMP; ++i) {
    LPCTSTR p = set.getString(ID_INIT_BMP + i);
    if(!p)
      break;
    appendPath(basePath, p);
    addBmp(basePath, i);
    *pPath = 0;
    }

  return true;
}
//-----------------------------------------------------------------------------
static float myRand(DWORD lim)
{
  return (float) (((double) rand() / (double) RAND_MAX) * lim + 0.5);
}
//-----------------------------------------------------------------------------
#define STEP_LIMIT 0.6
//-----------------------------------------------------------------------------
static float getRandStep()
{
  double v = ((double) rand() / (double) RAND_MAX) * 2 - STEP_LIMIT * 2;
  v -= 1 - STEP_LIMIT;
  if(v >= 0)
    v += STEP_LIMIT;
  else
    v -= STEP_LIMIT;
  return (float)v;
}
//-----------------------------------------------------------------------------
static void getRandInit(float& x, float& y)
{
  x = myRand(PShapeMov::szScreen.cx);
  y = myRand(PShapeMov::szScreen.cy);
}
//-----------------------------------------------------------------------------
void npScreenSaver::addBmp(LPCTSTR p, int zOrder)
{
  float x = getRandStep();
  float y = getRandStep();
  float z = float((((double) rand() / (double) RAND_MAX) * 0.005) + 0.001);
  if(rand() & 1)
    z = -z;
//  float z = 0.001;
  PBitmap bmp(p);

  PShape* sh;
  if(Display)
    sh = new npShapeD3D(&bmp, x, y, z, zOrder, Display->GetDevice());
  else
    sh = new npShape(&bmp, x, y, z, zOrder);
  getRandInit(x, y);
  z = float((((double) rand() / (double) RAND_MAX) * 0.5) + 0.5);
  if(sh->init(x, y, z)) {
    uint nElem = Shapes.getElem();
    Shapes[nElem] = sh;
    }
  else
    delete sh;
}
//-----------------------------------------------------------------------------
void npScreenSaver::setDirect(Direct::Draw* pdd)
{
  while(pdd) {
    int res = getCurrRes();
    if(24 != res && 32 != res)
      break;

    pOffSS = new Direct::OffScreenSurface(*pdd, PShapeMov::szScreen.cx, PShapeMov::szScreen.cy);
    if(!pOffSS)
      break;
    pPrimarySS = new Direct::PrimarySurface(*pdd);
    if(!pPrimarySS)
      break;
    pdDraw = pdd;
    ev_Paint = &npScreenSaver::evPaintDX;
    return;
    }
  delete pOffSS;
  delete pPrimarySS;
  delete pdDraw;
  pOffSS = 0;
  pPrimarySS = 0;
  pdDraw = 0;
  setGDIPaint();
}
//-----------------------------------------------------------------------------
void npScreenSaver::setGDIPaint()
{
  ev_Paint = &npScreenSaver::evPaintGDI;
  makeMDC();
}
//-----------------------------------------------------------------------------
void npScreenSaver::invalidate(PShape& shape)
{
  PRect r(0, 0, shape.getWidth(), shape.getHeight());
  r.MoveTo(ROUND_POS_REAL(shape.coord_X()), ROUND_POS_REAL(shape.coord_Y()));
  r.Inflate(1, 1);
  InvalidateRect(*this, r, false);
}
//-----------------------------------------------------------------------------
void npScreenSaver::evTimer(uint idT)
{
  uint nElem = Shapes.getElem();
  if(!nElem)
    return;
  npShapeMovLinear shapeMove;
  npShapeMovVarious shapeMove2;
  npShapeMovGravity shapeMove3;
  PShapeMov* movArray[] = { &shapeMove, &shapeMove2, &shapeMove3  };
  if(!casualMove.getElem())
    for(uint i = 0; i < nElem; ++i)
      casualMove[i] = rand() % SIZE_A(movArray);
  for(uint i = 0; i < nElem; ++i)
    Shapes[i]->move(*movArray[casualMove[i]]);

  if(Display)
    evPaint(0);
  else
    baseClass::evTimer(idT);
}
//-----------------------------------------------------------------------------
void npScreenSaver::evPaint(HDC hdc)
{
  if(ev_Paint)
    (this->*ev_Paint)(hdc);
}
//-----------------------------------------------------------------------------
void npScreenSaver::evPaintGDI(HDC hdc)
{
  PRect r(0, 0, PShapeMov::szScreen.cx, PShapeMov::szScreen.cy);
  int R;
  int G;
  int B;
  getRGB_BKG(R, G, B);
  COLORREF old = SetBkColor(mdcWork, RGB(R, G, B));
  ExtTextOut(mdcWork, 0, 0, ETO_OPAQUE, r, 0, 0, 0);
  SetBkColor(mdcWork, old);

  uint nElem = Shapes.getElem();
  for(uint i = 0; i < nElem; ++i)
    Shapes[i]->evPaint(mdcWork);
  BitBlt(hdc, 0, 0, r.Width(), r.Height(), mdcWork, 0, 0, SRCCOPY);
}
//-----------------------------------------------------------------------------
static void sort(PVect<PShape*>& target, const PVect<PShape*>& source)
{
  uint nElem = source.getElem();
  target.setDim(nElem);
  target[0] = source[0];
  for(uint i = 1; i < nElem; ++i) {
    target[i] = source[i];
    for(uint j = i; j > 0; --j) {
      if(target[j]->coord_Z() >= target[j - 1]->coord_Z())
        break;
      PShape* t = target[j - 1];
      target[j - 1] = target[j];
      target[j] = t;
      }
    }
}
//-----------------------------------------------------------------------------
extern bool useZOrder();
//-----------------------------------------------------------------------------
void npScreenSaver::evPaintD3D(HDC hdc)
{
  try {
    IDirect3DDevice9* device = Display->GetDevice();

    device->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    device->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    device->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    int res = Display->beginPaint();
    if(2 == res) {
      uint nElem = Shapes.getElem();
      if(useZOrder()) {
				PVect<PShape*> t;
				sort(t, Shapes);
				for(uint i = 0; i < nElem; ++i)
					t[i]->evPaint(0);
				}
			else {
				for(uint i = 0; i < nElem; ++i)
					Shapes[i]->evPaint(0);
				}
      Display->endPaint(true);
      }
    else if(1 == res)
      Display->endPaint(false);
    }
  catch(...) {
    setGDIPaint();
   }
}
//-----------------------------------------------------------------------------
void npScreenSaver::evPaintDX(HDC hdc)
{
  try {
    do {
      int R;
      int G;
      int B;
      getRGB_BKG(R, G, B);
      getOffSurface()->Fill (RGB (R, G, B));
      Direct::Canvas ddc(*getOffSurface());
      uint nElem = Shapes.getElem();
      for(uint i = 0; i < nElem; ++i)
        Shapes[i]->evPaint(ddc);
      } while(false);


    PRect r(0, 0, PShapeMov::szScreen.cx, PShapeMov::szScreen.cy);
    Direct::PrimarySurface& surf = *getPrimarySurface();
    surf.fastBltFrom(*getOffSurface(), r, r);
    }
  catch(...) {
    delete pOffSS;
    delete pPrimarySS;
    delete pdDraw;
    pOffSS = 0;
    pPrimarySS = 0;
    pdDraw = 0;
    setGDIPaint();
   }
}
//-----------------------------------------------------------------------------
