//------- pScreensaver.h -----------------------------------------------------
//----------------------------------------------------------------------------
#ifndef pScreensaver_H_
#define pScreensaver_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
#include <ScrnSave.h>
//----------------------------------------------------------------------------
#define IDTIMER 99
//----------------------------------------------------------------------------
class PScreenSaver
{
  public:
    PScreenSaver(HWND hwnd, uint msec = 50) : hwnd(hwnd), idTimer(0), mSec(msec) { }
    virtual ~PScreenSaver();

    virtual bool init() { return toBool(idTimer = SetTimer(hwnd, IDTIMER, mSec, 0)); }
    virtual void evTimer(uint idT) {  InvalidateRect(hwnd, 0, TRUE); }
    HWND GetWnd() const { return hwnd; }

    virtual void evPaint(HDC hdc) = 0;
    virtual bool eraseBkg() { return false; }
    operator HWND() const { return GetWnd(); }
  private:
    HWND hwnd;
    uint idTimer;
    uint mSec;
};
//----------------------------------------------------------------------------
PScreenSaver* allocScreenSaver(HWND hwnd);
//----------------------------------------------------------------------------
#endif
