//----------- P_TestIO.h ------------------------------------------------------
//----------------------------------------------------------------------------
#ifndef P_TESTIO_H_
#define P_TESTIO_H_
//----------------------------------------------------------------------------
#include "precHeader.h"
//----------------------------------------------------------------------------
#include <stdlib.h>
#include "resource.h"
//----------------------------------------------------------------------------
enum ioMsgCommand
{
    CM_ERROR_INIT = -1,
    CM_HWND       = 1,
    CM_MAIN_IS_CLOSING,
    CM_READ_PORT_BYTE,
    CM_WRITE_PORT_BYTE,
    CM_READ_PORT_WORD,
    CM_WRITE_PORT_WORD,
};
//----------------------------------------------------------------------------
class P_TestIO
{
  public:
    P_TestIO(HWND owner) : Owner(owner), remoteWin(0) {}
    virtual ~P_TestIO();

    bool init();

    HWND getHandle() const { return Owner; }
    operator HWND() const { return getHandle(); }
    BOOL windowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

  private:
    HWND Owner;
    void writePort();
    void readPort();
    void updateEdit(uint idCtrl);
    int  getDec(uint idCtrl);
    void setDec(uint idCtrl, int val);

    HWND remoteWin;
    bool openProcess();
};
//----------------------------------------------------------------------------
#endif
