//----------- P_TestIO.cpp ----------------------------------------------------
//----------------------------------------------------------------------------
#include "precHeader.h"
//----------------------------------------------------------------------------
#include <stdio.h>
#include <process.h>
//----------------------------------------------------------------------------
#include "macro_utils.h"
#include "P_TestIO.h"
//----------------------------------------------------------------------------
#define REG_(a) const UINT WM_##a = RegisterWindowMessage(_T("WM_") _T(#a))

REG_(IO_DRIVER_COMUNICATOR);
//----------------------------------------------------------------------------
P_TestIO::~P_TestIO()
{
  if(remoteWin)
    PostMessage(remoteWin, WM_IO_DRIVER_COMUNICATOR, CM_MAIN_IS_CLOSING, 0);
}
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
bool P_TestIO::openProcess()
{

  STARTUPINFO si;
  ZeroMemory(&si, sizeof(si));
  si.cb = sizeof(si);
  si.dwFlags = STARTF_FORCEONFEEDBACK | STARTF_USESHOWWINDOW;
  si.wShowWindow = SW_HIDE;

  PROCESS_INFORMATION pi;
  TCHAR path[_MAX_PATH];
  // rinominato solo per non trarre in inganno pensando che sia questo il programma user
  wsprintf(path, _T("%s /H%d"), _T("ioDriver.bin "), getHandle());
//  wsprintf(path, _T("%s /H%d"), _T("ioDriver.exe "), getHandle());
  if(CreateProcess(0, path, 0, 0, 0, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi)) {
    WaitForInputIdle(pi.hProcess, 3 * 1000);
    CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);
    return true;
    }
  return false;
}
//-----------------------------------------------------------------------------
bool P_TestIO::init()
{
  if(!openProcess()) {
    MessageBox(*this, _T("Unable to initialize the portDriver!"), _T("Error"), MB_OK | MB_ICONINFORMATION);
    PostQuitMessage(0);
    return false;
    }
  SET_CHECK(IDC_RADIOBUTTON_8_BIT);
  return true;
}
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
BOOL P_TestIO::windowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  if(WM_IO_DRIVER_COMUNICATOR == message) {
    switch(wParam) {
      case CM_ERROR_INIT:
        MessageBox(*this, _T("Unable to initialize the portDriver!"), _T("Error"), MB_OK | MB_ICONINFORMATION);
        PostQuitMessage(0);
        break;

      case CM_HWND:
        remoteWin = (HWND)lParam;
        break;
      }
    }
  switch(message) {

    case WM_COMMAND:
      switch(HIWORD(wParam)) {
        case EN_CHANGE:
          updateEdit(LOWORD(wParam));
          break;
        }
      switch(LOWORD(wParam)) {
        case IDCANCEL:
          PostQuitMessage(0);
          return 0;
        case IDC_BUTTON_WRITE:
          writePort();
          break;
        case IDC_BUTTON_READ:
          readPort();
          break;
        case IDC_RADIOBUTTON_8_BIT:
        case IDC_RADIOBUTTON_16_BIT:
          updateEdit(IDC_EDIT_VALUE_DEC);
          break;
        }
      break;
    }
  return FALSE;
}
//----------------------------------------------------------------------------
void P_TestIO::writePort()
{
  int addr = getDec(IDC_EDIT_ADDR_DEC);
  int value = getDec(IDC_EDIT_VALUE_DEC);
  DWORD dummy;
  DWORD command = CM_WRITE_PORT_BYTE;
  if(IS_CHECKED(IDC_RADIOBUTTON_16_BIT))
    command = CM_WRITE_PORT_WORD;
  SendMessageTimeout(remoteWin, WM_IO_DRIVER_COMUNICATOR, command, MAKELPARAM(addr, value),
                     SMTO_BLOCK, 2000, &dummy);
}
//----------------------------------------------------------------------------
void P_TestIO::readPort()
{
  int addr = getDec(IDC_EDIT_ADDR_DEC);
  DWORD value;
  DWORD command = CM_READ_PORT_BYTE;
  if(IS_CHECKED(IDC_RADIOBUTTON_16_BIT))
    command = CM_READ_PORT_WORD;
  if(!SendMessageTimeout(remoteWin, WM_IO_DRIVER_COMUNICATOR, command, MAKELPARAM(addr, 0),
                         SMTO_BLOCK, 2000, &value))
    return;
  int readed[] = {
    IDC_EDIT_READED_DEC, IDC_EDIT_READED_HEX, IDC_EDIT_READED_BIN
    };
  for(int i = 0; i < SIZE_A(readed); ++i)
    setDec(readed[i], value);
}
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
static int getDec(TCHAR car)
{
  if(car >= _T('0') && car <= _T('9'))
    return car - _T('0');
  if(car >= _T('a') && car <= _T('f'))
    return car - _T('a') + 10;
  if(car >= _T('A') && car <= _T('F'))
    return car - _T('A') + 10;
  return 0;
}
//----------------------------------------------------------------------------
static int hexToInt(LPCTSTR buff)
{
  int code = 0;
  int len = _tcslen(buff);
  for(int i = len - 1, j = 0; i >= 0; --i, ++j) {
    int val = getDec(buff[i]);
    val <<= j * 4;
    code += val;
    }
  return code;
}
//----------------------------------------------------------------------------
static void intToHex(LPTSTR buff, int val, bool isWord)
{
  if(isWord)
    wsprintf(buff, _T("%04X"), val);
  else
    wsprintf(buff, _T("%02X"), val);
}
//----------------------------------------------------------------------------
static int binToInt(LPCTSTR buff)
{
  int code = 0;
  int len = _tcslen(buff);
  for(int i = len - 1, j = 0; i >= 0; --i, ++j) {
    if(_T('1') == buff[i])
      code |= 1 << j;
    }
  return code;
}
//----------------------------------------------------------------------------
static void intToBin(LPTSTR buff, int val, int len)
{
  for(int i = len - 1; i >= 0; --i) {
    buff[i] = _T('0') + (val & 1);
    val >>= 1;
    }
  buff[len] = 0;
}
//----------------------------------------------------------------------------
int P_TestIO::getDec(uint idCtrl)
{
  TCHAR buff[30];
  GetDlgItemText(*this, idCtrl, buff, SIZE_A(buff));

  switch(idCtrl) {
    case IDC_EDIT_ADDR_DEC:
    case IDC_EDIT_VALUE_DEC:
      return _ttoi(buff);
    case IDC_EDIT_ADDR_HEX:
    case IDC_EDIT_VALUE_HEX:
      return hexToInt(buff);
    case IDC_EDIT_VALUE_BIN:
      return binToInt(buff);
    }
  return 0;
}
//----------------------------------------------------------------------------
void P_TestIO::setDec(uint idCtrl, int val)
{
  TCHAR buff[30];
  bool isWord = IS_CHECKED(IDC_RADIOBUTTON_16_BIT);
  switch(idCtrl) {
    case IDC_EDIT_ADDR_DEC:
    case IDC_EDIT_VALUE_DEC:
    case IDC_EDIT_READED_DEC:
      SetDlgItemInt(*this, idCtrl, val, 0);
      break;
    case IDC_EDIT_ADDR_HEX:
    case IDC_EDIT_VALUE_HEX:
    case IDC_EDIT_READED_HEX:
      intToHex(buff, val, isWord);
      SetDlgItemText(*this, idCtrl, buff);
      break;
    case IDC_EDIT_VALUE_BIN:
    case IDC_EDIT_READED_BIN:
      intToBin(buff, val, isWord ? 16 : 8);
      SetDlgItemText(*this, idCtrl, buff);
      break;
    }
}
//----------------------------------------------------------------------------
void P_TestIO::updateEdit(uint idCtrl)
{
  static bool myChange;
  if(myChange)
    return;
  myChange = true;
  uint id[] = {
    IDC_EDIT_ADDR_DEC, IDC_EDIT_VALUE_DEC,
    IDC_EDIT_ADDR_HEX, IDC_EDIT_VALUE_HEX,
    0, IDC_EDIT_VALUE_BIN,
    };
  for(int i = 0; i < SIZE_A(id); ++i) {
    if(idCtrl == id[i]) {
      int val = getDec(idCtrl);
      for(int j = i - 2; j >= 0; j -= 2)
        setDec(id[j], val);
      for(int j = i + 2; j < SIZE_A(id); j += 2)
        setDec(id[j], val);
      break;
      }
    }
  myChange = false;
}
//----------------------------------------------------------------------------
